<?php

/**
 * 
 * @param ApiUserService $apiUserService
 */
function authenticateApiUser($apiUserService) {
    $token = null;
    
    if(isset(apache_request_headers()["Authorization"])) {
        $header = apache_request_headers()["Authorization"];
        $token =  substr($header, 6); // Taking substring after 6th letter <Basic token>
    }
    
    if(!$apiUserService->isBasicAuthenticationTokenValid($token)) {
        header('WWW-Authenticate: Basic realm="Restricted access"');
        header('HTTP/1.0 401 Unauthorized');
        die ("Not authorized");
    }
}

